/*
 * Netrek player DB maintenance
 *
 * main.c - startup & shutdown, plus some common routines
 */
#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <curses.h>
#include <varargs.h>
#include "pledit.h"


void
usage(argv0)
char *argv0;
{
    fprintf(stderr, "usage: %s [.players] [.global]\n\n", argv0);
    fprintf(stderr,
    "DO NOT use this or any other score tool while a game is in progress.\n\n");
}


/*
 * fatal(int errno, char *format, arg1, arg2, ...)
 */
/* VARARGS */
void
fatal(va_alist)
va_dcl
{
    va_list args;
    char *format;

    endwin();		/* shut curses down before printing error */

    va_start(args);
    errno = (int) va_arg(args, int);
    format = (char *) va_arg(args, char *);

    fflush(stdout);
    fprintf(stderr, "%s: ", "pledit");	/* (or argv[0]) */
#ifdef NO_VFPRINTF
    fprintf(stderr, "a fatal error occurred");	/* lazy */
#else
    vfprintf(stderr, format, args);
#endif

    if (errno > 0)
        perror(" ");
    else
        putc('\n', stderr);

    va_end(args);

    exit(1);
    /*NOTREACHED*/
}


/*
 * Handle fatal signals (like SIGINT)
 */
void
signal_handler()
{
    endwin();		/* shut curses down */
    exit(3);
    /*NOTREACHED*/
}


main(argc, argv)
int argc;
char **argv;
{
    char *pl_filename, *gl_filename;

    if (argc > 3) {
	usage(argv[0]);
	exit(2);
    }

    if (argc >= 2)
	pl_filename = argv[1];
    else
	pl_filename = PLAYERFILE;
    if (argc == 3)
	gl_filename = argv[2];
    else
	gl_filename = GLOBAL;

    signal(SIGINT, signal_handler);

    /* init curses */
    if (initscr() == NULL) {
	fprintf(stderr, "Unable to initialize curses\n");
	exit(1);
    }

    edit_file(pl_filename, gl_filename);

    /* shut down curses */
    endwin();
    exit(0);
    /*NOTREACHED*/
}

