/*
 * main.c
 *
 * For the Berkeley client (Mar 28 '93) with GATEWAY/TREKHOPD extensions
 */
#include "copyright.h"

#ifdef __STDC__
#include <stdlib.h>
#endif
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include <setjmp.h>
#include <pwd.h>
#ifdef hpux
#include <time.h>
#else /*hpux*/
#include <time.h>
#include <sys/time.h>
#endif /*hpux*/
#ifndef hpux
#include <sys/wait.h>
#endif /*hpux*/
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include "packets.h"


#ifdef EM
#include "prog_version.h"
#endif

jmp_buf env;

#ifdef GATEWAY	/*-----------------------------------------------------------*/

/*
 * IMPORTANT IMPORTANT IMPORTANT IMPORTANT IMPORTANT IMPORTANT IMPORTANT
 *
 * Set MYADDR and MYADDR_MASK to however much of the address is significant.
 * For example, I want to restrict the use of my clients to the 129.212
 * subnet (all machines within Amdahl), so I set MYADDR=0x81d40000, and
 * MYADDR_MASK to be 0xffff0000.  The host's address will be ANDed with the
 * mask and then compared to MYADDR.
 *
 * If you only want your client to be run on your host, then you'd use all
 * eight bytes.
 */
#define MYADDR		0x81d40000
#define MYADDR_MASK	0xffff0000

/* we want these for the client subnet validation */
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>

extern char *getenv();
char *home, homedot[256];

#define DEFAULT_GATEWAY		"charon"

char		*get_gw();
unsigned long 	mkaddr();


unsigned long netaddr;		/* used for blessedness checking */
int serv_port;			/* used for blessedness checking */

static char *gateway = DEFAULT_GATEWAY;

#ifdef TREKHOPD
static int trekhopd_port = 6592;
int use_trekhopd = 0;
int port_req = 6592;
char *host_req = "vlsi";
#endif


typedef struct {
    char id[16];
    char inet_addr[24];
    int  remote_port;
    int  gw_port;
    char full_name[64];
    char comment[40];
} SERVER_LIST;
#define MAX_SERVER      64
static SERVER_LIST servers[MAX_SERVER];         /* that ought to be enough */
#define SERVER_DIR      "/usr/local/games/"
#define SERVER_FILE     ".trekgwrc"
static int server_count = 0;
#define WSPC    " \t"


unsigned long
strToNetaddr( str )
char *str;
{
    SERVER_LIST *slp;
    char *t;
    unsigned long answer;
    int i;

    if (!server_count) {
        fprintf(stderr, "No server list, cannot resolve id\n");
        exit(1);
    }

    /* find the one we want */
    for (i = 0, slp = servers; i < server_count; i++, slp++) {
        if (!strcmp(str, slp->id)) {
            printf("%s is %s(%d) (%s)\n", slp->id, slp->full_name,
                slp->remote_port, slp->comment);
            xtrekPort = slp->gw_port;
            str = slp->inet_addr;
            break;
        }
    }
   if (i == server_count) {
        fprintf(stderr, "Specified server not found.\n");
        return (-1);
    }

    /* now "str" is either the original string or slp->inet_addr */
    /* (this will be wrong if -H isn't last on command line) */
    answer=0;
    t=str;
    for (i=0; i<4; i++) {
        answer=(answer<<8) | atoi(t);
        while (*t && *t != '.') t++;
        if (*t) t++;
    }
#ifdef TREKHOPD
    /* do things slightly different */
    if (slp->id == NULL) {
        fprintf(stderr, "ERROR: host ID '%s' unknown\n", str);
        exit(1);
    }
    xtrekPort = trekhopd_port;          /*ought to have an arg to specify this*/
    port_req = slp->remote_port;
    host_req = slp->full_name;
    printf("Connecting to %s (%d) via trekhopd (%s %d)\n", host_req,
       port_req, serverName, xtrekPort);
#else
    printf("Connecting to %s through %s port %d\n", str, serverName, xtrekPort);
#endif
    return(answer);
}


/* for trekhopd, only gw_local_port is important */
/* (should be possible to eliminate that too, but I want minimal changes) */
typedef struct {
    int uid;
    int serv_port;
    int port;
    int local_port;
} UDPMAP;
#define MAX_UDPMAP      32
static UDPMAP udpmap[MAX_UDPMAP];
static int map_count;

getUdpPort()
{
    int i;
    uid_t uid;
    char		*gw_m,
			*gw_p,
			*gw_lp,
			*gw_sp, 
			*err,
			*getenv();

    /* should always be set prior, but in case not .. */
    if(!gw_mach){
       gw_m = getenv("GW_MACH");
       if(gw_m)
	 gw_mach = gw_m;
       else
	 gw_mach = DEFAULT_GATEWAY;
    }

    uid = getuid();

    for (i = 0; i < map_count; i++) {
        if (uid == udpmap[i].uid) {
            gw_serv_port = udpmap[i].serv_port;
            gw_port = udpmap[i].port;
            gw_local_port = udpmap[i].local_port;
            return;
        }
    }
    printf("unable to get ports for your uid\n");	/* debug */

    gw_p = getenv("GW_PORT");
    gw_sp = getenv("GW_SPORT");
    gw_lp = getenv("GW_LPORT");

   if(gw_p){
      gw_port = strtol(gw_p, &err, 10);
      if(err==gw_p){
	 fprintf(stderr, "netrek: malformed integer for GW_PORT: %s\n",
	    gw_p);
	 /* let something else complain about port 0 */
      }
   }
   else
      gw_port = 5001;
   if(gw_sp){
      gw_serv_port = strtol(gw_sp, &err, 10);
      if(err==gw_sp){
	 fprintf(stderr, "netrek: malformed integer for GW_SPORT: %s\n",
	    gw_sp);
	 /* let something else complain about port 0 */
      }
   }
   else
      gw_serv_port = 5000;

   if(gw_lp){
      gw_local_port = strtol(gw_lp, &err, 10);
      if(err==gw_lp){
	 fprintf(stderr, "netrek: malformed integer for GW_LPORT: %s\n",
	    gw_lp);
	 /* let something else complain about port 0 */
      }
   }
   else
      gw_local_port = 5000;
   
   /*
   printf("gw_mach: \'%s\'\n", gw_mach);
   printf("gw_local_port: %d\n", gw_local_port);
   printf("gw_serv_port: %d\n", gw_serv_port);
   printf("gw_port: %d\n", gw_port);
   */
}

/*
 * In the event of problems assiocated with the above include files the 
 * following routine can be alternately used to convert a string 
 * ("xxx.xxx.xxx.xxx") to an internet address number.
 */

#ifdef notneeded
unsigned long
dotAddrToNetAddr(str)

   char	*str;
{
   char *t;
   unsigned long answer=0;
   t=str;
   for (i=0; i<4; i++) {
      answer=(answer<<8) | atoi(t);
      while (*t && *t != '.') t++;
      if (*t) t++;
   }
   return answer;
}
#endif

/*
 * More network "correct" routine
 */

unsigned long
mkaddr(m)

   char *m;
{
   struct in_addr       ad;
   struct hostent       *hp;

   hp = gethostbyname(m);
   if(!hp){
      ad.s_addr = inet_addr(m);
      if(ad.s_addr == -1){
         fprintf(stderr, "netrek: unknown host \'%s\'\n", m);
         exit(1);
      }
   }
   else
      bcopy(hp->h_addr, (char *)&ad, hp->h_length);

   return ad.s_addr;
}
char *
get_gw()
{
   char *gw_m;

   gw_m = getenv("GW_MACH");
   if(gw_m)
      gw_mach = gw_m;
   else
      gw_mach = gateway;
   
   return gw_mach;
}

/*
 * This is not very robust.
 */
void
read_servers()
{
    FILE *fp;
    SERVER_LIST *slp;
    UDPMAP *ump;
    char buf[128];
    int state;
    char *cp;

    server_count = map_count = 0;

    fp = NULL;
    if (getenv("HOME") != NULL) {
	strcpy(homedot, getenv("HOME"));
	strcat(homedot, "/");
	strcat(homedot, SERVER_FILE);
	fp = fopen(homedot, "r");
    }
    if (fp == NULL) {
	/* failed, try common one */
	strcpy(buf, SERVER_DIR);
	strcat(buf, SERVER_FILE);
	fp = fopen(buf, "r");
    }
    if (fp == NULL) {
	/* failed, try current directory */
	fp = fopen(SERVER_FILE, "r");
    }
    if (fp == NULL) {
	/* failed, give up */
	perror("warning: Unable to open server list");
	fprintf(stderr, "Tried to open '%s', '%s', and './%s'\n",
		homedot, buf, SERVER_FILE);
	return;
    }

    state = 0;
    while (1) {
        fgets(buf, 128, fp);
        if (ferror(fp) || feof(fp)) {
            if (ferror(fp)) perror("fgets");
            break;
        }

        /* skip blank lines and lines which start with '#' */
        if (*buf == '\0' || *buf == '\n' || *buf == '#') continue;
        buf[strlen(buf)-1] = '\0';      /* strip the trailing '\n' */

        switch (state) {
        case 0:         /* "trekhopd" or "gw" */
#ifdef TREKHOPD
            use_trekhopd = 0;
            if (!strcmp(buf, "trekhopd")) use_trekhopd = 1;
#endif
            state++;
            break;
        case 1:         /* gateway host */
            gateway = (char *)malloc(strlen(buf)+1);
            strcpy(gateway, buf);
            state++;
            break;
        case 2:         /* trekhopd port */
            trekhopd_port = atoi(buf);
            state++;
            break;
        case 3:         /* UDP map */
            if (!strcmp(buf, "END")) {
                state++;
                break;
            }
            ump = &udpmap[map_count];
            cp = strtok(buf, WSPC);     /* skip ascii uid */
            cp = strtok(NULL, WSPC);
            ump->uid = atoi(cp);
            cp = strtok(NULL, WSPC);
            ump->serv_port = atoi(cp);
            cp = strtok(NULL, WSPC);
            ump->port = atoi(cp);
            cp = strtok(NULL, WSPC);
            ump->local_port = atoi(cp);
#ifdef DEBUG
            printf("%2d: %-8d %-8d %-8d %-8d\n", map_count,
                ump->uid, ump->serv_port, ump->port, ump->local_port);
#endif
            map_count++;
            break;

        case 4:         /* host description */
            if (!strcmp(buf, "END")) {
                state++;
                break;
            }
            slp = &servers[server_count];
            cp = strtok(buf, WSPC);
            strcpy(slp->id, cp);
            cp = strtok(NULL, WSPC);
            strcpy(slp->inet_addr, cp);
            cp = strtok(NULL, WSPC);
            slp->remote_port = atoi(cp);
            cp = strtok(NULL, WSPC);
            slp->gw_port = atoi(cp);
            cp = strtok(NULL, WSPC);
            strcpy(slp->full_name, cp);
            cp = strtok(NULL, "\"\t");
            strcpy(slp->comment, cp);
#ifdef DEBUG
            printf("%2d: %-9s %-15s %-5d %-5d %-25s \"%s\"\n", server_count,
                slp->id, slp->inet_addr, slp->remote_port, slp->gw_port,
                slp->full_name, slp->comment);
#endif
            server_count++;
            break;
        case 5:         /* all done! */
            break;
        default:
            fprintf(stderr, "Whoops!\n");
            exit(2);
        }
    }

    fclose(fp);
}


#endif GATEWAY				/* end of gateway-specific mass */

/* ------------------------------------------------------------------------- */


#ifdef MOO
char *recordFileName=NULL;      /* Added recorder <isae> */
char *logFileName=NULL;         /* Log message <isae> */
#endif

#ifdef EM
void handle_segfault();
void handle_exception();
#endif

#ifdef PACKET_LOG
extern int log_packets;
#endif

#ifdef FOR_MORONS
extern int For_Morons;
#endif

main(argc, argv)
int argc;
char **argv;
{
    int intrupt();
    int team, s_type;
    int pno;
    char *host = NULL;
    int usage = 0;
    int err = 0;
    char *name, *ptr, *cp, *rindex();
    char buf[80];
    struct passwd *pwent, *getpwuid();
    int reaper();
    int passive=0;
    extern char *getenv();
#ifdef GATEWAY
    int hset=0;
#endif
    char *defaultsFile=getenv("XTREKRC");
#ifdef TSH
    int first=1;
    char	*log;
#endif /*TSH*/

#ifdef GATEWAY
    /* restrict this client to certain machines */
    {
	struct sockaddr_in saddr;
	struct hostent *hp;
	char myname[64];
	long myaddr;

	if (gethostname(myname, 64) < 0) {
	    perror("gethostname");
	    exit(1);
	}
	if ((myaddr = inet_addr(myname)) == -1) {
	    if ((hp = gethostbyname(myname)) == NULL) {
		fprintf(stderr, "unable to get addr for local host\n");
		exit(1);
	    }
	    myaddr = *(long *) hp->h_addr;
	}

	/*printf("myname = '%s', myaddr = 0x%.8lx\n", myname, myaddr);*/
	if ((myaddr & MYADDR_MASK) != MYADDR) {
	    fprintf(stderr,"Sorry, you may not run this client on this host\n");
	    exit(1);
	}
    }
#endif

    name = *argv++;
    argc--;
    if ((ptr = rindex(name, '/')) != NULL)
	name = ptr + 1;
#ifdef GATEWAY
    read_servers();
    netaddr = 0;
    serverName = gateway;
#endif
    while (*argv) {
	if (**argv == '-')
	    ++*argv;
	else
	    break;

	argc--;
	ptr = *argv++;
	while (*ptr) {
	    switch (*ptr) {
	    case 'u': usage++; break;
	    case 's': 
		if (*argv) {
		    xtrekPort=atoi(*argv); 
		    passive=1; 
		    argv++; 
		    argc--; 
		}
		break;
	    case 'p':
		if (*argv) {
		    xtrekPort=atoi(*argv);
		    argv++;
		    argc--;
		} 
		break;
	    case 'd':
		host = *argv;
		argc--;
		argv++;
		break;
#ifdef RSA
	    case 'o':
                RSA_Client = -1; /* will be reset leter, set negative here
				 ** to flag that it should override xtrekrc */
                printf("Using standard binary verification\n");
		break;
	    case 'R':
		RSA_Client = -2; /* will be reset leter, set negative here
				 ** to flag that it should override xtrekrc */
		printf("Using RSA binary verification\n");
		break;
#else
	    case 'R':
		printf("This client does not support RSA binary verification\n");
	    case 'o':
                printf("Using standard binary verification\n");
		break;
#endif
#ifdef FOR_MORONS
	    case 'M':
		if(For_Morons){
		    For_Morons = 0;
		} else {
		    For_Morons = 1;
		}
		break;
#endif
	    case 'h':
		serverName = *argv;
#ifdef GATEWAY
		gw_mach = *argv;
#endif
		argc--;
		argv++;
		break;
#ifdef GATEWAY
	    case 'H':
		hset++;
		netaddr = strToNetaddr(*argv);
		/*netaddrstr = *argv;*/
		argc--;
		argv++;
		break;
#endif

#ifdef TSH
	    case 't':
		title = *argv;
		argc--;
		argv++;
		break;
#endif /*TSH*/
	    case 'r':
		defaultsFile = *argv;
		argv++;
		argc--;
		break;
	       
	    case 'D':
		debug ++;
		break;
#ifdef PACKET_LOG
	    case 'P':
		log_packets++;
		break;
#endif
#ifdef MOO
            case 'f':
                recordFileName = *argv;
                argv++;
                argc--;
                break;
            case 'l':
                logFileName = *argv;
		argv++;
		argc--;
		break;
#endif /* MOO */
	    default: 
		fprintf(stderr, "%s: unknown option '%c'\n", name, *ptr);
		err++;
		break;
	    }
	    ptr++;
	}
    }

#ifdef EXPIRATIONDATE
    {
	time_t nowtime;
	nowtime = time(NULL);
	if(nowtime > EXPIRATIONDATE){
	    printf("This program has reached its planned-obsolescence date!\n")
	    printf("Please try to get a newer version!\n");
	    exit(666);
	} else {
	    nowtime = EXPIRATIONDATE;
	    printf("This program will become non-functioonal after %s\n"
		ctime(&nowtime));
	}
    }
#endif

#ifdef MOO
    /* open game recorder file */
    if (recordFileName != NULL) {
      recordFile = fopen(recordFileName, "wb");
      if (recordFile == NULL) {
      perror(recordFileName);
      exit(1);

        }
    }
    /* open messages logfile */
    if (logFileName != NULL) {
      logFile = fopen(logFileName, "w+");
      if (logFile == NULL) {
        perror(logFileName);
        exit(1);
      }
    }
#endif /* MOO */

#ifdef GATEWAY
    if (!hset) use_trekhopd = 0;	/* allow use via normal connections */
    if(netaddr == 0) {
	fprintf(stderr, 
"netrek: no remote address set (-H).  Restricted server will not work.\n");
    }
#endif
#ifdef EM
#ifndef NO_TRAP
    SIGNAL(SIGSEGV, handle_segfault);
    SIGNAL(SIGFPE, handle_exception);
#endif /* DEBUG */
#endif /* EM */
    initDefaults(defaultsFile);
    if (usage || err) {
	printUsage(name);
	exit(err);
    }
    /* compatability */
    if (argc > 0)
	host = argv[0];
    srandom(getpid() * time((long *) 0));
    /* this creates the necessary x windows for the game */

#ifdef EM
    /* server nicknames:
    ** if you do netrek -h foo
    ** and "server.foo:		netrek.netrek.com" exists in your netrekrc
    ** the server that is called is netrek.netrek.com
    ** also, port.foo: x   will make the port called x
    */
    if(serverName){
	char defaulttmp[100];
	char *temp, *temp2;
	temp2 = serverName;
	sprintf(defaulttmp, "server.%s", serverName);
	if((temp=getdefault(defaulttmp)) != NULL){
	    IFDEBUG(printf("using server nickname %s for %s\n",temp, serverName );)
	    serverName = temp;
	}
	IFDEBUG(else printf("couldn't find server nickname for %s \n", temp );)
	/* default port to go with this server */
	if( xtrekPort < 0 ){
	    int port_temp;
	    sprintf(defaulttmp, "port.%s", temp2);
	    if((port_temp=intDefault(defaulttmp, -1))  >=0 ){
		IFDEBUG(printf("using port %d for server nickname %s \n", port_temp,temp );)
		xtrekPort = port_temp;
	    }
		IFDEBUG(else printf("couldn't find port for server nickname %s \n", temp );)
	
	}
#ifdef RSA
	/* RSA on/off to go with server too! */
	if(RSA_Client >=0){
	    sprintf(defaulttmp, "useRSA.%s", temp2);
	    RSA_Client = booleanDefault(defaulttmp, RSA_Client);
	    IFDEBUG(printf("useRSA for server is %d \n", RSA_Client );)
	}
#endif
    }
#endif
#ifdef TSH 
   if(!serverName)
      serverName = getdefault("server");
   if(!serverName)
      serverName = DEFAULT_SERVER;
	
#ifdef nodef	/* this is used above as EM 8/
   /* suggested by milutz@icaen.uiowa.edu */
   if(serverName){
      char	*temp;
      char	*ts = (char *)strdup(serverName);
      if((temp = getdefault(ts)) != NULL){
	 printf("%s is redefined as %s by your configurations file.\n",
	    serverName, temp);
	 serverName = temp;
      }
      free((char *) ts);
   }
#endif
	
   if(xtrekPort < 0)
      xtrekPort = intDefault("port", -1);
   if(xtrekPort < 0)
      xtrekPort = DEFAULT_PORT;

#ifdef GATEWAY
    /* pick a nice set of UDP ports */
    getUdpPort();
#endif

#endif TSH

#ifdef RSA
    if(RSA_Client >=0 ){
	RSA_Client = booleanDefault("useRSA", RSA_Client);
    } else {
	/* RSA mode was specified in the command line args */
	RSA_Client = ( RSA_Client == -2) ? 1 : 0 ;
    }
#endif
#ifdef FOR_MORONS
    For_Morons = booleanDefault("ForMorons", For_Morons);
#endif
    newwin(host, name); /* open memory...? Leftover from xtrek code! */
    openmem();

    /* Get login name (must do BEFORE connecting for trekhopd) */
    if ((pwent = getpwuid(getuid())) != NULL)
	(void) strncpy(login, pwent->pw_name, sizeof(login));
    else
	(void) strncpy(login, "Bozo", sizeof(login));
    login[sizeof(login) - 1] = '\0';

    if (!passive) {
	callServer(xtrekPort, serverName);
    } else {
	connectToServer(xtrekPort);
    }

#ifdef MOO
    showMotdOnQ=booleanDefault("waitMotd",showMotdOnQ);
#endif
    findslot();

    lastm = mctl->mc_current;
    mapAll();
    SIGNAL(SIGINT, SIG_IGN);
    (void) SIGNAL(SIGCHLD, reaper);

    if ((cp = getdefault("name")) != 0)
	(void) strncpy(pseudo, cp, sizeof(pseudo));
    else
	(void) strncpy(pseudo, login, sizeof(pseudo));
    pseudo[sizeof(pseudo) - 1] = '\0';

    getname(pseudo);
    loggedIn=1;

#ifdef MOO
    /* moo does it all in readDefaults in getdefault.c */
    readDefaults();

#else /* MOO */

    showShields = booleanDefault("showshields", showShields);
    showStats = booleanDefault("showstats", showStats);
    keeppeace = booleanDefault("keeppeace", keeppeace);
    reportKills = booleanDefault("reportkills", reportKills);
#ifdef TSH
    showMySpeed = booleanDefault("showMySpeed", showMySpeed);
    showTractorPressor = booleanDefault("showTractorPressor", showTractorPressor);
#ifdef EM
    showLock = intDefault("showLock", showLock);
#else
    showLock = booleanDefault("showLock", showLock);
#endif /* EM */
    fillTriangle = booleanDefault("fillTriangle", fillTriangle);

    extraBorder = booleanDefault("extraAlertBorder", extraBorder);
#ifdef ATM
    udpDebug 		= intDefault("udpDebug", udpDebug);
    udpClientSend	= intDefault("udpClientSend", udpClientSend);
    /* note: requires send */
    udpClientRecv	= intDefault("udpClientReceive", udpClientRecv);
    tryUdp		= booleanDefault("tryUdp", tryUdp);
    udpSequenceChk	= booleanDefault("udpSequenceCheck", udpSequenceChk);
#endif /*ATM*/
#endif /*TSH*/

#ifdef NOWARP
    warp		= booleanDefault("warp", warp);
#endif

#ifdef EM
    sortPlayers = booleanDefault("sortplayers", sortPlayers);
#endif

#ifdef NETSTAT
    netstat		= booleanDefault("netstats", netstat);
    netstatfreq		= intDefault("netstatfreq", netstatfreq);
    if(netstatfreq <= 0)
      netstatfreq = 1;
#endif

    initkeymap();
    sendOptionsPacket();

#endif MOO

    /* Set p_hostile to hostile, so if keeppeace is on, the guy starts off
       hating everyone (like a good fighter should) */
    me->p_hostile = (FED|ROM|KLI|ORI);

    sprintf(buf,
      "Maximum:      %2d  %3d %3d               %3d   %6d   %3d   %3d",
      0, 0, 0, 0, 0, 0, 0);
    W_WriteText(tstatw,50,27,textColor,buf,strlen(buf),W_RegularFont);
    me->p_planets=0;
    me->p_genoplanets=0;
    me->p_armsbomb=0;
    me->p_genoarmsbomb=0;
    /* Set up a reasonable default */
    me->p_whydead=KQUIT;
    me->p_team=ALLTEAM;
    s_type = defaultShip(CRUISER);

#ifdef PING
    /* this will always be done once.  If the server doesn't support ping
       packets it will ignore this request */
    startPing();
#endif

    setjmp(env);		/* Reentry point of game */

    /* give the player the motd and find out which team he wants */
    entrywindow(&team, &s_type);
    if (team == -1) {
	W_DestroyWindow(w);
	sendByeReq();
	sleep(1);
	printf("OK, bye!\n");
#ifdef PACKET_LOG
        if(log_packets)
	    Dump_Packet_Log_Info();
#endif
	exit(0);
    }
    getship(myship, myship->s_type);
    redrawall = 1;
    enter();
    calibrate_stats();
    W_ClearWindow(w);
    W_ClearWindow(mapw);
    /*
    for (i = 0; i < NSIG; i++) {
	SIGNAL(i, SIG_IGN);
    }
    */

    me->p_status = PALIVE;			/* Put player in game */
    me->p_ghostbuster = 0;

    if (showStats)			/* Default showstats are on. */
	W_MapWindow(statwin);

#ifdef NETSTAT
    if(W_IsMapped(lMeter))
	redrawLMeter();
#endif

#ifdef PING
    if(W_IsMapped(pStats))
        redrawPStats();
#endif


#if TSH && ATM
   if(tryUdp && commMode != COMM_UDP){
      sendUdpReq(COMM_UDP);
   }
   if(udpWin){
      /* update any fields affected by xtrekrc */
      udprefresh(UDP_SEQUENCE);
      udprefresh(UDP_DEBUG);
      udprefresh(UDP_SEND);
      udprefresh(UDP_RECV);
   }
#endif /*TSH*/

    /* Get input until the player quits or dies */
    input();
}

/* } */

printUsage(prog)
	char	*prog;
{
	printf("Usage: %s [options] [display-name]\n",prog);
	printf("Options:\n"); 
	printf(" [-h servername]     Specify a server\n");
	printf(" [-p port number]     Specify a port to connect to\n");
	printf(" [-r defaultsfile]   Specify defaults file\n");
	printf(" [-s socketnum]      Specify listen socket port for manual start\n");
#ifdef TSH
	printf(" [-t title]          Set title\n");
#endif
	printf(" [-u]   show usage\n");
	printf(" [-D]   increase debugging level (repeat to increase)\n");
#ifdef GATEWAY
	printf(" [-H]   specify host (via gateway)\n");
#endif
#ifdef RSA
	printf(" [-o]   use old-style binary verification)\n");
	printf(" [-R]   use RSA binary verification\n");
	printf("	Installed RSA key: %s\n", Key_Version); 
#endif
#ifdef FOR_MORONS
	printf(" [-M]   Toggle netrek-for-morons mode\n");
#endif
#ifdef PACKET_LOG
	printf(" [-P]   Log server packets, repeat for increased information\n");
#endif
#ifdef MOO
	printf(" [-f filename]   Record game into 'filename'\n");
	printf(" [-l filename]   Record messages into 'filename'\n");
#endif
	printf("version: %s\n", Program_Version); 
}

reaper()
{
#ifdef hpux
    wait((int *) 0);
#else hpux
    while (wait3((union wait *) 0, WNOHANG, NULL) > 0)
	;
#endif /*hpux*/
}

#ifdef EM
/*
**    code to mention that there was an error, but not to crash
**    catastrophicly. This may need to be hacked to have a limit
**    of errors per update or something, to keep from having runaway
**    segfualt loops dumping endlessly to a tty.
*/
int errcount=0;
void handle_segfault(){
      printf("segmentation error detected; attempting to continue\n");
      if(errcount++ > 10)
	SIGNAL(SIGSEGV, SIG_DFL);
	/* core dump normally on next error */
}
void handle_exception(){
      printf("floating exception error detected; attempting to continue\n");
      if(errcount++ > 10)
	SIGNAL(SIGSEGV, SIG_DFL);
	/* core dump normally on next error */
}
#endif

#ifdef _UTS
char *alloca(size)
int size;
{
    /* this is a *bad* way to do it */
    extern char *malloc();
    return((char *) malloc(size));
}
#endif

