/*
 * main.c
 */
#include "copyright.h"

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <setjmp.h>
#include <pwd.h>
#ifdef hpux
#include <time.h>
#else	/* hpux */
#include <sys/time.h>
#endif				/* hpux */
#ifndef hpux
#include <sys/wait.h>
#endif				/* hpux */
#include <sys/file.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include "packets.h"

#ifdef EM
#include "prog_version.h"
#endif

jmp_buf         env;


#ifdef GATEWAY
extern unsigned long netaddr;	/* used for blessedness checking */
int             serv_port;	/* used for blessedness checking */

static char    *gateway = "codes";

#ifdef TREKHOPD
static int      trekhopd_port = 6592;
int             use_trekhopd = 0;
int             port_req = 6592;
char           *host_req = "vlsi";
#endif

typedef struct {
   char            id[16];
   char            inet_addr[24];
   int             remote_port;
   int             gw_port;
   char            full_name[64];
   char            comment[40];
}               SERVER_LIST;
#define MAX_SERVER      128
static SERVER_LIST servers[MAX_SERVER];	/* that ought to be enough */
#define SERVER_DIR      "/usr/local/games/"
#define SERVER_FILE     ".trekgwrc"
static int      server_count = 0;
#define WSPC    " \t"


unsigned long
strToNetaddr(str)
    char           *str;
{
   SERVER_LIST    *slp;
   char           *t;
   unsigned long   answer;
   int             i;

   if (!server_count) {
      fprintf(stderr, "No server list, cannot resolve id\n");
      exit(1);
   }
   /* find the one we want */
   for (i = 0, slp = servers; i < server_count; i++, slp++) {
      if (!strcmp(str, slp->id)) {
	 printf("%s is %s(%d) (%s)\n", slp->id, slp->full_name,
		slp->remote_port, slp->comment);
	 xtrekPort = slp->gw_port;
	 str = slp->inet_addr;
	 break;
      }
   }
   if (i == server_count) {
      fprintf(stderr, "Specified server not found.\n");
      return (-1);
   }
   /* now "str" is either the original string or slp->inet_addr */
   /* (this will be wrong if -H isn't last on command line) */
   answer = 0;
   t = str;
   for (i = 0; i < 4; i++) {
      answer = (answer << 8) | atoi(t);
      while (*t && *t != '.')
	 t++;
      if (*t)
	 t++;
   }
#ifdef TREKHOPD
   /* do things slightly different */
   if (slp->id == NULL) {
      fprintf(stderr, "ERROR: host ID '%s' unknown\n", str);
      exit(1);
   }
   xtrekPort = trekhopd_port;	/* ought to have an arg to specify this */
   port_req = slp->remote_port;
   host_req = slp->full_name;
   printf("Connecting to %s (%d) via trekhopd (%s %d)\n", host_req,
	  port_req, serverName, xtrekPort);
#else
   printf("Connecting to %s through %s port %d\n", str, serverName, xtrekPort);
#endif
   return (answer);
}


/* for trekhopd, only gw_local_port is important */
/* (should be possible to eliminate that too, but I want minimal changes) */
typedef struct {
   int             uid;
   int             serv_port;
   int             port;
   int             local_port;
}               UDPMAP;
#define MAX_UDPMAP      32
static UDPMAP   udpmap[MAX_UDPMAP];
static int      map_count;

getUdpPort()
{
   int             i;
   uid_t           uid;

   uid = getuid();

   gw_mach = gateway;
   for (i = 0; i < map_count; i++) {
      if (uid == udpmap[i].uid) {
	 gw_serv_port = udpmap[i].serv_port;
	 gw_port = udpmap[i].port;
	 gw_local_port = udpmap[i].local_port;
	 return;
      }
   }

   /* not recognized; use default UDP port */
   gw_serv_port = 5000;
   gw_port = 5001;
   gw_local_port = 5000;
}


/*
 * This is not very robust.
 */
void
read_servers()
{
   FILE           *fp;
   SERVER_LIST    *slp;
   UDPMAP         *ump;
   char            buf[128];
   int             state;
   char           *cp;
   extern char	  *getenv();

   server_count = map_count = 0;

   fp = NULL;
   if (getenv("HOME") != NULL) {
      strcpy(buf, getenv ("HOME"));
      strcat(buf, "/");
      strcat(buf, SERVER_FILE);
      fp = fopen(buf, "r");
   }
   if (fp == NULL) {
      /* failed, try common one */
      strcpy(buf, SERVER_DIR);
      strcat(buf, SERVER_FILE);
      fp = fopen (buf, "r");
   }
   if (fp == NULL) {
      /* failed, try current directory */
      fp = fopen(SERVER_FILE, "r");
   }
   if (fp == NULL) {
      /* failed, give up */
      perror("warning: Unable to open server list");
      fprintf(stderr, "Tried to open $HOME/%s, '%s', and './%s'\n",
	       SERVER_FILE, buf, SERVER_FILE);
      return;
   }

   state = 0;
   while (1) {
      fgets(buf, 128, fp);
      if (ferror(fp) || feof(fp)) {
	 if (ferror(fp))
	    perror("fgets");
	 break;
      }
      /* skip blank lines and lines which start with '#' */
      if (*buf == '\0' || *buf == '\n' || *buf == '#')
	 continue;
      buf[strlen(buf) - 1] = '\0';	/* strip the trailing '\n' */

      switch (state) {
      case 0:			/* "trekhopd" or "gw" */
#ifdef TREKHOPD
	 use_trekhopd = 0;
	 if (!strcmp(buf, "trekhopd"))
	    use_trekhopd = 1;
#endif
	 state++;
	 break;
      case 1:			/* gateway host */
	 gateway = (char *) malloc(strlen(buf) + 1);
	 strcpy(gateway, buf);
	 state++;
	 break;
      case 2:			/* trekhopd port */
	 trekhopd_port = atoi(buf);
	 state++;
	 break;
      case 3:			/* UDP map */
	 if (!strcmp(buf, "END")) {
	    state++;
	    break;
	 }
	 if (map_count >= MAX_UDPMAP) {
	    fprintf(stderr, "UDP map too large; max is %d entries\n",
		MAX_UDPMAP);
	    break;
	 }
	 ump = &udpmap[map_count];
	 cp = strtok(buf, WSPC);/* skip ascii uid */
	 cp = strtok(NULL, WSPC);
	 ump->uid = atoi(cp);
	 cp = strtok(NULL, WSPC);
	 ump->serv_port = atoi(cp);
	 cp = strtok(NULL, WSPC);
	 ump->port = atoi(cp);
	 cp = strtok(NULL, WSPC);
	 ump->local_port = atoi(cp);
#ifdef DEBUG
	 printf("%2d: %-8d %-8d %-8d %-8d\n", map_count,
		ump->uid, ump->serv_port, ump->port, ump->local_port);
#endif
	 map_count++;
	 break;

      case 4:			/* host description */
	 if (!strcmp(buf, "END")) {
	    state++;
	    break;
	 }
	 if (server_count >= MAX_SERVER) {
	    fprintf(stderr, "server list too large; max is %d entries\n",
		MAX_SERVER);
	    break;
	 }
	 slp = &servers[server_count];
	 cp = strtok(buf, WSPC);
	 strcpy(slp->id, cp);
	 cp = strtok(NULL, WSPC);
	 strcpy(slp->inet_addr, cp);
	 cp = strtok(NULL, WSPC);
	 slp->remote_port = atoi(cp);
	 cp = strtok(NULL, WSPC);
	 slp->gw_port = atoi(cp);
	 cp = strtok(NULL, WSPC);
	 strcpy(slp->full_name, cp);
	 cp = strtok(NULL, "\"\t");
	 strcpy(slp->comment, cp);
#ifdef DEBUG
	 printf("%2d: %-9s %-15s %-5d %-5d %-25s \"%s\"\n", server_count,
		slp->id, slp->inet_addr, slp->remote_port, slp->gw_port,
		slp->full_name, slp->comment);
#endif
	 server_count++;
	 break;
      case 5:			/* all done! */
	 break;
      default:
	 fprintf(stderr, "Whoops!\n");
	 exit(2);
      }
   }

   fclose(fp);
}

#endif				/* GATEWAY */

#ifdef RECORD
char           *recordFileName = NULL;	/* Added recorder <isae> */
#endif
#ifdef LOGMESG
char           *logFileName = NULL;	/* Log message <isae> */
#endif

#ifdef EM
void            handle_segfault();
void            handle_exception();
#endif
void		get_core();	/* NEW */

#ifdef PACKET_LOG
extern int      log_packets;
#endif

#ifdef FOR_MORONS
extern int      For_Morons;
#endif

char           *defaultsFile;

main(argc, argv)
    int             argc;
    char          **argv;
{
   int             intrupt();
   int             team, s_type;
   int             pno;
   char           *host = NULL;
   int             usage = 0;
   int             err = 0;
   char           *name, *ptr, *cp, *rindex();
   char            buf[80];
   struct passwd  *pwent, *getpwuid();
   int             reaper();
   int             passive = 0;
   extern char    *getenv();
#ifdef PING
   int		   no_ping = 0;
#endif
   int             first = 1;
   char           *log;
#ifdef SPTEST
   int		   sptest=0;
#endif
   int		   noargs = (argc == 1);
   defaultsFile = getenv("XTREKRC");

   name = *argv++;
   argc--;
   if ((ptr = rindex(name, '/')) != NULL)
      name = ptr + 1;
#ifdef GATEWAY
   read_servers();
   netaddr = 0;
   serverName = gateway;
#endif
   while (*argv) {
      if (**argv == '-')
	 ++* argv;
      else
	 break;

      argc--;
      ptr = *argv++;
      while (*ptr) {
	 switch (*ptr) {
	 case 'u':
	    usage++;
	    break;
	 case 's':
	    if (*argv) {
	       xtrekPort = atoi(*argv);
	       passive = 1;
	       argv++;
	       argc--;
	    }
	    break;
	 case 'p':
	    if (*argv) {
	       xtrekPort = atoi(*argv);
	       argv++;
	       argc--;
	    }
	    break;
	 case 'd':
	    host = *argv;
	    argc--;
	    argv++;
	    break;
#ifdef RSA
	 case 'o':
	    RSA_Client = -1;	/* will be reset leter, set negative here *
				 * to flag that it should override xtrekrc */
	    printf("Using standard binary verification\n");
	    break;
	 case 'R':
	    RSA_Client = -2;	/* will be reset leter, set negative here *
				 * to flag that it should override xtrekrc */
	    printf("Using RSA binary verification\n");
	    break;
#else
	 case 'R':
	    printf("This client does not support RSA binary verification\n");
	 case 'o':
	    printf("Using standard binary verification\n");
	    break;
#endif
#ifdef FOR_MORONS
	 case 'M':
	    if (For_Morons) {
	       For_Morons = 0;
	    } else {
	       For_Morons = 1;
	    }
	    break;
#endif
	 case 'h':
	    serverName = *argv;
	    argc--;
	    argv++;
	    break;
#ifdef GATEWAY
	 case 'H':
	    netaddr = strToNetaddr(*argv);
	    argc--;
	    argv++;
	    break;
#endif

	 case 't':		/* USED?? */
	    title = *argv;
	    argc--;
	    argv++;
	    break;
	 case 'r':
	    defaultsFile = *argv;
	    argv++;
	    argc--;
	    break;

	 case 'D':
	    debug++;
	    break;
#ifdef PACKET_LOG
	 case 'P':
	    log_packets++;
	    break;
#endif
#ifdef RECORD
	 case 'f':
	    recordFileName = *argv;
	    argv++;
	    argc--;
	    break;
#endif				/* MOO */
#ifdef LOGMESG
	 case 'l':
	    logMess = 1;
	    logFileName = *argv;
	    argv++;
	    argc--;
	    break;
#endif
#ifdef SPTEST
	 case 'S':
	    spt_getwin(atoi(*argv));
	    argv++;
	    argc--;
	    break;
#endif
	 default:
	    fprintf(stderr, "%s: unknown option '%c'\n", name, *ptr);
	    err++;
	    break;
	 }
	 ptr++;
      }
   }

#ifdef EXPIRATIONDATE
   {
      time_t          nowtime;
      nowtime = time(NULL);
      if (nowtime > EXPIRATIONDATE) {
	 printf("This program has reached its planned-obsolescence date!\n")
	    printf("Please try to get a newer version!\n");
	 exit(666);
      } else {
	 nowtime = EXPIRATIONDATE;
	 printf("This program will become non-functioonal after %s\n"
		ctime(&nowtime));
      }
   }
#endif

#ifdef RECORD
   /* open game recorder file */
   if (recordFileName != NULL) {
      recordFile = fopen(recordFileName, "wb");
      if (recordFile == NULL) {
	 perror(recordFileName);
	 exit(1);

      }
   }
#endif				/* MOO */
#ifdef LOGMESG
   /* open messages logfile */
   if (logFileName != NULL) {
      logFile = fopen(logFileName, "w+");
      if (logFile == NULL) {
	 perror(logFileName);
	 exit(1);
      }
   }
#endif

#ifdef GATEWAY
   if (netaddr == 0) {
      fprintf(stderr,
	      "netrek: no remote address set (-H).  Restricted server will not work.\n");
   }
#endif
#ifdef EM
#ifndef NO_TRAP
   signal(SIGSEGV, handle_segfault);
   signal(SIGFPE, handle_exception);
#endif				/* DEBUG */
#endif				/* EM */
   signal(SIGPIPE, SIG_IGN);

   initDefaults(defaultsFile);
   if (usage || err || argc > 0) {
      printUsage(name, noargs);
      exit(1);
   }
#ifdef SHOW_DEFAULTS
   show_defaults("startup", "zeroArgUsage", "on",
      "If no arguments, print usage instead of looking for default server.");
#endif
   if(noargs && booleanDefault("zeroArgUsage", 1)){
      printUsage(name, noargs);
      exit(1);
   }

#ifdef nodef
   /* compatability */
   if (argc > 0)
      host = argv[0];
#endif

   srandom(getpid() * time((long *) 0));
   /* this creates the necessary x windows for the game */

#ifdef RSA
   if (RSA_Client >= 0) {
#ifdef SHOW_DEFAULTS
	 show_defaults("startup", "useRSA", RSA_Client?"on":"off",
	    "Use RSA verification.");
#endif
      RSA_Client = booleanDefault("useRSA", RSA_Client);
   } else {
      /* RSA mode was specified in the command line args */
      RSA_Client = (RSA_Client == -2) ? 1 : 0;
   }
#endif

#ifdef EM
   /*
    * server nicknames: * if you do netrek -h foo * and "server.foo:
    * etrek.netrek.com" exists in your netrekrc * the server that is called
    * is netrek.netrek.com * also, port.foo: x   will make the port called x
    */
   if (serverName) {
      char            defaulttmp[100];
      char           *temp, *temp2;
      temp2 = serverName;
      sprintf(defaulttmp, "server.%s", serverName);
#ifdef SHOW_DEFAULTS
      show_defaults("startup", "server.alias", "x.y.z",
	 "Aliases.  Replace x.y.z with full server name, and specify <alias>\n\
From then on you can specify that server by doing 'netrek -h <alias>'");
#endif
      if ((temp = getdefault(defaulttmp)) != NULL) {
	 IFDEBUG(printf("using server nickname %s for %s\n", temp, serverName);)
	 serverName = temp;
      }
      IFDEBUG( else
		printf("couldn't find server nickname for %s \n", temp);)
      /* default port to go with this server */
      if (xtrekPort < 0) {
	 int             port_temp;
	 sprintf(defaulttmp, "port.%s", temp2);
#ifdef SHOW_DEFAULTS
	 show_defaults("startup", "port.x.y.z", "2592",
	    "Default port to use with server x.y.z.\n\
NOTE: if x.y.z is aliased (server.alias: x.y.z), use the alias instead.");
#endif
	 if ((port_temp = intDefault(defaulttmp, -1)) >= 0) {
	    IFDEBUG(printf("using port %d for server nickname %s \n", port_temp, temp);)
	    xtrekPort = port_temp;
	 }
	 IFDEBUG( else
	    printf("couldn't find port for server nickname %s \n", temp);)
      }
#ifdef RSA
      /* RSA on/off to go with server too! */
      if (RSA_Client >= 0) {
	 sprintf(defaulttmp, "useRSA.%s", temp2);
#ifdef SHOW_DEFAULTS
	 show_defaults("startup", "useRSA.x.y.z", RSA_Client?"on":"off",
	    "Default RSA use for server x.y.z.\n\
NOTE: if x.y.z is aliased (server.alias: x.y.z), use the alias instead.");
#endif
	 RSA_Client = booleanDefault(defaulttmp, RSA_Client);
	 IFDEBUG(printf("useRSA for server is %d \n", RSA_Client);)
      }
#endif
   }
#endif

   if (!serverName)
      serverName = getdefault("server");
   if (!serverName)
      serverName = DEFAULT_SERVER;
#ifdef SHOW_DEFAULTS
   show_defaults("startup", "server", "default.server.edu",
      "Name of the default server to use if the -h flag isn't given.");
#endif

#ifdef nodef			/* this is used above as EM 8/ /* suggested
				 * by milutz@icaen.uiowa.edu */
   if (serverName) {
      char           *temp;
      char           *ts = (char *) strdup(serverName);
      if ((temp = getdefault(ts)) != NULL) {
	 printf("%s is redefined as %s by your configurations file.\n",
		serverName, temp);
	 serverName = temp;
      }
      free((char *) ts);
   }
#endif

   if (xtrekPort < 0)
      xtrekPort = intDefault("port", -1);
   if (xtrekPort < 0)
      xtrekPort = DEFAULT_PORT;

#ifdef GATEWAY
   /* pick a nice set of UDP ports */
   getUdpPort();
#endif

#ifdef FOR_MORONS
#ifdef SHOW_DEFAULTS
	 show_defaults("misc", "forMorons", For_Morons?"on":"off",
	    "EM");
#endif
   For_Morons = booleanDefault("ForMorons", For_Morons);
#endif
   newwin(host, name);		/* open memory...? Leftover from xtrek code! */

   openmem();
   if (!passive) {
      callServer(xtrekPort, serverName);
   } else {
      connectToServer(xtrekPort);
   }

#ifdef MOO
#ifdef SHOW_DEFAULTS
   show_defaults("startup", "waitMotd", showMotdOnQ?"on":"off",
      "Show the motd while on the wait q.");
#endif
   showMotdOnQ = booleanDefault("waitMotd", showMotdOnQ);
#endif

   findslot();

   lastm = mctl->mc_current;
   mapAll();
   signal(SIGINT, SIG_IGN);

   /* Get login name */
   if ((pwent = getpwuid(getuid())) != NULL)
      (void) strncpy(login, pwent->pw_name, sizeof(login));
   else
      (void) strncpy(login, "Bozo", sizeof(login));
   login[sizeof(login) - 1] = '\0';

#ifdef SHOW_DEFAULTS
   show_defaults("startup", "name", "your-name-here",
      "The default player name shown at the login window.\n");
#endif
   if ((cp = getdefault("name")) != 0)
      (void) strncpy(pseudo, cp, sizeof(pseudo));
   else
      (void) strncpy(pseudo, login, sizeof(pseudo));
   pseudo[sizeof(pseudo) - 1] = '\0';

   getname(pseudo);
   loggedIn = 1;

   /* moo does it all in readDefaults in getdefault.c */
   readDefaults();

   /*
    * Set p_hostile to hostile, so if keeppeace is on, the guy starts off
    * hating everyone (like a good fighter should)
    */
   me->p_hostile = (FED | ROM | KLI | ORI);

   /*
   sprintf(buf,
	   "Maximum:      %2d  %3d %3d               %3d   %6d   %3d   %3d",
	   0, 0, 0, 0, 0, 0, 0);
   W_WriteText(tstatw, 50, 27, textColor, buf, strlen(buf), W_RegularFont);
   */
   me->p_planets = 0;
   me->p_genoplanets = 0;
   me->p_armsbomb = 0;
   me->p_genoarmsbomb = 0;
   /* Set up a reasonable default */
   me->p_whydead = KQUIT;
   me->p_team = ALLTEAM;
   s_type = defaultShip(CRUISER);

#ifdef PING
#ifdef SHOW_DEFAULTS
   show_defaults("startup", "dontPing", "off",
      "Don't attempt to start ping packets from the server.");
#endif
   no_ping = booleanDefault("DontPing", 0);
   /*
    * this will always be done once.  If the server doesn't support ping
    * packets it will ignore this request
    */
   if(!no_ping)
      startPing();
#endif

#ifdef XSIG
   xsig_start();
#endif

   setjmp(env);			/* Reentry point of game */

   if (messageon)
      message_off();            /* ATM */

   /* give the player the motd and find out which team he wants */
   entrywindow(&team, &s_type);
   if (team == -1) {
      W_DestroyWindow(w);
      sendByeReq();
      sleep(1);
      printf("OK, bye!\n");
#ifdef PACKET_LOG
      if (log_packets)
	 Dump_Packet_Log_Info();
#endif
#ifdef SHOW_DEFAULTS
      finish_defaults();
#endif
      exit(0);
   }
#ifdef FEATURE
   sendVersion();
#endif
   getship(myship, myship->s_type);
   redrawall = 1;
   enter();
   calibrate_stats();
   W_ClearWindow(w);
   W_ClearWindow(mapw);
   /*
    * for (i = 0; i < NSIG; i++) { signal(i, SIG_IGN); }
    */

   me->p_status = PALIVE;	/* Put player in game */
   me->p_ghostbuster = 0;
   updatePlayer[me->p_no] = 1;

   if (showStats)		/* Default showstats are on. */
      W_MapWindow(statwin);

#ifdef NETSTAT
   if (W_IsMapped(lMeter))
      redrawLMeter();
#endif

#ifdef PING
   if (W_IsMapped(pStats))
      redrawPStats();
#endif


   if (tryUdp && commMode != COMM_UDP) {
      sendUdpReq(COMM_UDP);
   }
   if (udpWin) {
      /* update any fields affected by xtrekrc */
      udprefresh(UDP_SEQUENCE);
      udprefresh(UDP_DEBUG);
      udprefresh(UDP_SEND);
      udprefresh(UDP_RECV);
   }

#ifdef SHORT_PACKETS		/* should we be checking for udp on here? */
   if (tryShort) {
      sendShortReq(SPK_VON);
      tryShort = 0;		/* do it once only */
   }
#endif

   /* Get input until the player quits or dies */
   input();
}

/* } */

printUsage(prog, noargs)
   char           *prog;
   int		noargs;
{
#ifdef RSA
   extern char	key_name[],client_arch[];	/* rsa-client.c */
#endif
   fprintf(stderr, "BRMH %s usage: %s [options]\n\n", VERSION, prog);
   fprintf(stderr, "Where common options include:\n");
   fprintf(stderr, "   [-h servername]     Specify a server\n");
   fprintf(stderr, "   [-p port number]    Specify a port to connect to\n");
   fprintf(stderr, "\nOther options:\n");
   fprintf(stderr, "   [-r defaultsfile]   Specify defaults file\n");
   fprintf(stderr, "   [-d display]        Specify X display\n");
   fprintf(stderr, "   [-s socketnum]      Specify listen socket port for manual start\n");
   fprintf(stderr, "   [-u]                This message.\n");
   fprintf(stderr, "   [-D]                Debugging level (repeat to increase)\n");
#ifdef GATEWAY
   fprintf(stderr, "   [-H gateway]        Specify gateway machine\n");
#endif
#ifdef RSA
   fprintf(stderr, "   [-o]                Use old-style binary verification\n");
   fprintf(stderr, "   [-R]                Use RSA binary verification\n");
#endif
#ifdef FOR_MORONS
   fprintf(stderr, "   [-M]                Toggle netrek-for-morons mode\n");
#endif
#ifdef PACKET_LOG
   fprintf(stderr, "   [-P]                Log server packets, repeat for increased information\n");
#endif
#ifdef MOO
   fprintf(stderr, "   [-l filename]       Record messages into 'filename'\n");
#endif
   fprintf(stderr, "\nAt runtime, select 'show help window' for a list of commands.\n");
#ifdef XTREKRC_HELP
   fprintf(stderr, "Select 'show xtrekrc window' for a list of .xtrekrc options.\n");
#endif
   fprintf(stderr, "For a detailed description of the .xtrekrc, see the file\n");
   fprintf(stderr, "BRMH-%s.<client>-xtrekrc.default at the ftp site where you got this binary.\n", VERSION);
   fprintf(stderr, "For server information and lots of other things read rec.games.netrek.\n");
   if(noargs){
      fprintf(stderr, "\nTo use the default server when no arguments are specified\n");
      fprintf(stderr, "(instead of showing this message), add:\n");
      fprintf(stderr, "   zeroArgUsage: off\n");
      fprintf(stderr, "to your .xtrekrc.\n");
   }
}

reaper()
{
#ifdef hpux
   wait((int *) 0);
#else	/* hpux */
   while (wait3((union wait *) 0, WNOHANG, NULL) > 0);
#endif				/* hpux */
}

#ifdef EM
/*
 * *    code to mention that there was an error, but not to crash *
 * catastrophicly. This may need to be hacked to have a limit *    of errors
 * per update or something, to keep from having runaway *    segfualt loops
 * dumping endlessly to a tty.
 */
int             errcount = 0;
void 
handle_segfault()
{
   printf("segmentation error detected; attempting to continue\n");
   if (errcount++ > 10)
      signal(SIGSEGV, SIG_DFL);
   /* core dump normally on next error */
}
void 
handle_exception()
{
   printf("floating exception error detected; attempting to continue\n");
   if (errcount++ > 10)
      signal(SIGSEGV, SIG_DFL);
   /* core dump normally on next error */
}
#endif

void
get_core()
{
   fprintf(stderr, "SIGPIPE\n");
   abort();
}

#ifdef XSIG
xsig_start()
{
   int	x = W_Socket();

   signal(SIGIO, SIG_IGN);
   fcntl(x, F_SETFL, (FNDELAY|FASYNC));
   fcntl(x, F_SETOWN, getpid());
}

xsig_on()
{
   extern int sigio_handler();
   signal(SIGIO, sigio_handler);
}

xsig_off()
{
   signal(SIGIO, SIG_IGN);
}
#endif
