/*
 * main.c
 *
 * Modified to work with "gw" or "trekhopd".
 */
#include "copyright.h"

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include <setjmp.h>
#include <pwd.h>
#ifdef hpux
#include <time.h>
#else hpux
#include <sys/time.h>
#endif hpux
#ifndef hpux
#include <sys/wait.h>
#endif hpux
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include "packets.h"

extern void *malloc();

#ifdef GATEWAY	/* --------------------------------------------------------- */

/*
 * IMPORTANT IMPORTANT IMPORTANT IMPORTANT IMPORTANT IMPORTANT IMPORTANT
 *
 * Set MYADDR and MYADDR_MASK to however much of the address is significant.
 * For example, I want to restrict the use of my clients to the 129.212
 * subnet (all machines within Amdahl), so I set MYADDR=0x81d40000, and
 * MYADDR_MASK to be 0xffff0000.  The host's address will be ANDed with the
 * mask and then compared to MYADDR.
 *
 * If you only want your client to be run on your host, then you'd use all
 * eight bytes.
 */
#define MYADDR          0x81d40000
#define MYADDR_MASK     0xffff0000

/* we want these for the client subnet validation */
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>

extern char *getenv();
char *home, homedot[256];

#define DEFAULT_GATEWAY	"charon"

unsigned long netaddr;		/* used for blessedness checking */
int serv_port;			/* used for blessedness checking */
char *netaddrstr;		/* useful for nicer wait queue title */

static char *gateway = DEFAULT_GATEWAY;

#ifdef TREKHOPD
static int trekhopd_port = 6592;
int use_trekhopd = 0;
int port_req = 6592;
char *host_req = "tde.uts.amdahl.com";
#endif


typedef struct {
    char id[16];
    char inet_addr[24];
    int  remote_port;
    int  gw_port;
    char full_name[64];
    char comment[40];
} SERVER_LIST;
#define MAX_SERVER	64
static SERVER_LIST servers[MAX_SERVER];		/* that ought to be enough */
#define SERVER_DIR	"/usr/local/games/"
#define SERVER_FILE	".trekgwrc"
static int server_count = 0;
#define WSPC	" \t"


unsigned long
strToNetaddr( str )
char *str;
{
    SERVER_LIST *slp;
    char *t;
    unsigned long answer;
    int i;

    if (!server_count) {
	fprintf(stderr, "No server list, cannot resolve id\n");
	exit(1);
    }

    /* find the one we want */
    for (i = 0, slp = servers; i < server_count; i++, slp++) {
	if (!strcmp(str, slp->id)) {
	    printf("%s is %s(%d) (%s)\n", slp->id, slp->full_name,
		slp->remote_port, slp->comment);
	    xtrekPort = slp->gw_port;
	    str = slp->inet_addr;
	    break;
	}
    }
    if (i == server_count) {
	fprintf(stderr, "Specified server not found.\n");
	return (0);
    }

    /* now "str" is either the original string or slp->inet_addr */
    /* (this will be wrong if -H isn't last on command line) */
    answer=0;
    t=str;
    for (i=0; i<4; i++) {
	answer=(answer<<8) | atoi(t);
	while (*t && *t != '.') t++;
	if (*t) t++;
    }
#ifdef TREKHOPD
    /* do things slightly different */
    if (slp->id == NULL) {
	fprintf(stderr, "ERROR: host ID '%s' unknown\n", str);
	exit(1);
    }
    xtrekPort = trekhopd_port;		/*ought to have an arg to specify this*/
    port_req = slp->remote_port;
    host_req = slp->full_name;
    printf("Connecting to %s (%d) via trekhopd (%s %d)\n", host_req,
	port_req, serverName, xtrekPort);
#else
    printf("Connecting to %s through %s port %d\n", str, serverName, xtrekPort);
#endif
    return(answer);
}


/* for trekhopd, only gw_local_port is important */
/* (should be possible to eliminate that too, but I want minimal changes) */
typedef struct {
    int uid;
    int serv_port;
    int port;
    int local_port;
} UDPMAP;
#define MAX_UDPMAP	32
static UDPMAP udpmap[MAX_UDPMAP];
static int map_count;

getUdpPort()
{
    int i;
    uid_t uid;

    uid = getuid();

    gw_mach = gateway;
    for (i = 0; i < map_count; i++) {
	if (uid == udpmap[i].uid) {
	    gw_serv_port = udpmap[i].serv_port;
	    gw_port = udpmap[i].port;
	    gw_local_port = udpmap[i].local_port;
	    return;
	}
    }

    /* not recognized; use default UDP port */
    gw_serv_port = 5000;
    gw_port = 5001;
    gw_local_port = 5000;
}


/*
 * This is not very robust.
 */
void
read_servers()
{
    FILE *fp;
    SERVER_LIST *slp;
    UDPMAP *ump;
    char buf[128];
    int state;
    char *cp;

    server_count = map_count = 0;

    if (getenv("HOME") != NULL) {
        strcpy(homedot, getenv("HOME"));
        strcat(homedot, "/");
        strcat(homedot, SERVER_FILE);
        if ((fp = fopen(homedot, "r")) == NULL) {
            /* failed, try common one */
            strcpy(buf, SERVER_DIR);
            strcat(buf, SERVER_FILE);
            if ((fp = fopen(buf, "r")) == NULL) {
                perror("warning: Unable to open server list");
                fprintf(stderr, "Tried to open '%s' and '%s'\n",
                        homedot, buf);
                return;
            }
        }
    }

    state = 0;
    while (1) {
	fgets(buf, 128, fp);
	if (ferror(fp) || feof(fp)) {
	    if (ferror(fp)) perror("fgets");
	    break;
	}

	/* skip blank lines and lines which start with '#' */
	if (*buf == '\0' || *buf == '\n' || *buf == '#') continue;
	buf[strlen(buf)-1] = '\0';	/* strip the trailing '\n' */

	switch (state) {
	case 0:		/* "trekhopd" or "gw" */
#ifdef TREKHOPD
	    use_trekhopd = 0;
	    if (!strcmp(buf, "trekhopd")) use_trekhopd = 1;
#endif
	    state++;
	    break;
	case 1:		/* gateway host */
	    gateway = malloc(strlen(buf)+1);
	    strcpy(gateway, buf);
	    state++;
	    break;
	case 2:		/* trekhopd port */
	    trekhopd_port = atoi(buf);
	    state++;
	    break;
	case 3:		/* UDP map */
	    if (!strcmp(buf, "END")) {
		state++;
		break;
	    }
	    ump = &udpmap[map_count];
	    cp = strtok(buf, WSPC);	/* skip ascii uid */
	    cp = strtok(NULL, WSPC);
	    ump->uid = atoi(cp);
	    cp = strtok(NULL, WSPC);
	    ump->serv_port = atoi(cp);
	    cp = strtok(NULL, WSPC);
	    ump->port = atoi(cp);
	    cp = strtok(NULL, WSPC);
	    ump->local_port = atoi(cp);
#ifdef DEBUG
	    printf("%2d: %-8d %-8d %-8d %-8d\n", map_count,
		ump->uid, ump->serv_port, ump->port, ump->local_port);
#endif
	    map_count++;
	    break;

	case 4:		/* host description */
	    if (!strcmp(buf, "END")) {
		state++;
		break;
	    }
	    slp = &servers[server_count];
	    cp = strtok(buf, WSPC);
	    strcpy(slp->id, cp);
	    cp = strtok(NULL, WSPC);
	    strcpy(slp->inet_addr, cp);
	    cp = strtok(NULL, WSPC);
	    slp->remote_port = atoi(cp);
	    cp = strtok(NULL, WSPC);
	    slp->gw_port = atoi(cp);
	    cp = strtok(NULL, WSPC);
	    strcpy(slp->full_name, cp);
	    cp = strtok(NULL, "\"\t");
	    strcpy(slp->comment, cp);
#ifdef DEBUG
	    printf("%2d: %-9s %-15s %-5d %-5d %-25s \"%s\"\n", server_count,
		slp->id, slp->inet_addr, slp->remote_port, slp->gw_port,
		slp->full_name, slp->comment);
#endif
	    server_count++;
	    break;
	case 5:		/* all done! */
	    break;
	default:
	    fprintf(stderr, "Whoops!\n");
	    exit(2);
	}
    }

    fclose(fp);
}

#endif /*GATEWAY*/ /* ------------------------------------------------------ */

jmp_buf env;

main(argc, argv)
int argc;
char **argv;
{
    int intrupt();
    int team, s_type;
    int pno;
    char *host = NULL;
    int usage = 0;
    int err = 0;
    char *name, *ptr, *cp, *rindex();
    char buf[80];
    struct passwd *pwent, *getpwuid();
    int reaper();
    int passive=0;
    char *defaultsFile=NULL;
#ifdef GATEWAY
    int hset=0;
#endif

#ifdef GATEWAY
    /* restrict this client to certain machines */
    {
	struct sockaddr_in saddr;
	struct hostent *hp;
	char myname[64];
	long myaddr;

	if (gethostname(myname, 64) < 0) {
	    perror("gethostname");
	    exit(1);
	}
	if ((myaddr = inet_addr(myname)) == -1) {
	    if ((hp = gethostbyname(myname)) == NULL) {
		fprintf(stderr, "unable to get addr for local host\n");
		exit(1);
	    }
	    myaddr = *(long *) hp->h_addr;
	}

	/*printf("myname = '%s', myaddr = 0x%.8lx\n", myname, myaddr);*/
	if ((myaddr & MYADDR_MASK) != MYADDR) {
	    fprintf(stderr,"Sorry, you may not run this client on this host\n");
	    exit(1);
	}
    }
#endif

    name = *argv++;
    argc--;
    if ((ptr = rindex(name, '/')) != NULL)
	name = ptr + 1;

#ifdef GATEWAY
    read_servers();		/* read trekhopd server list */
    netaddr = 0;		/* default IP addr */
    serverName = gateway;	/* default is gateway host */
#endif

    while (*argv) {
	if (**argv == '-')
	    ++*argv;
	else
	    break;

	argc--;
	ptr = *argv++;
	while (*ptr) {
	    switch (*ptr) {
	    case 'u': usage++; break;
	    case 's': 
		if (*argv) {
		    xtrekPort=atoi(*argv); 
		    passive=1; 
		    argv++; 
		    argc--; 
		}
		break;
	    case 'p':
		if (*argv) {
		    xtrekPort=atoi(*argv);
		    argv++;
		    argc--;
		} 
		break;
	    case 'd':
		host = *argv;
		argc--;
		argv++;
		break;
	    case 'h':
		serverName = *argv;
		argc--;
		argv++;
		break;
	    case 'r':
		defaultsFile = *argv;
		argv++;
		argc--;
		break;
	    case 'o':
		RSA_Client = 0;
		break;
#ifdef GATEWAY
	    case 'H':
		hset++;
		netaddr = strToNetaddr( *argv );
		netaddrstr = *argv;	/* use this in wait queue window */
		argv++;
		argc--;
		break;
#endif
	    default: 
		fprintf(stderr, "%s: unknown option '%c'\n", name, *ptr);
		err++;
		break;
	    }
	    ptr++;
	}
    }
#ifdef GATEWAY
    if (!hset) use_trekhopd = 0;        /* allow use via normal connections */
    if(netaddr == 0) {
        fprintf(stderr,
"netrek: no remote address set (-H).  Restricted server will not work.\n");
    }
#endif
    initDefaults(defaultsFile);
    if (usage || err) {
	printUsage(name);
	exit(err);
    }
    /* compatability */
    if (argc > 0)
	host = argv[0];
    srandom(getpid() * time((long *) 0));
    /* this creates the necessary x windows for the game */
    newwin(host, name);
    /* open memory...? */
    openmem();

    /* Get login name (relocated for trekhopd) */
    if ((pwent = getpwuid(getuid())) != NULL)
	(void) strncpy(login, pwent->pw_name, sizeof(login));
    else
	(void) strncpy(login, "Bozo", sizeof(login));
    login[sizeof(login) - 1] = '\0';

    if ((cp = getdefault("name")) != 0)
	(void) strncpy(pseudo, cp, sizeof(pseudo));
    else
	(void) strncpy(pseudo, login, sizeof(pseudo));
    pseudo[sizeof(pseudo) - 1] = '\0';

#ifdef GATEWAY
    /* pick a nice set of UDP ports for trekhopd */
    getUdpPort();
#endif

    if (!passive) {
	callServer(xtrekPort, serverName);
    } else {
	connectToServer(xtrekPort);
    }

    findslot();

    mapAll();
    sigset(SIGINT, SIG_IGN);
    (void) sigset(SIGCHLD, reaper);

    getname(pseudo);
    loggedIn=1;

    showShields = booleanDefault("showshields", showShields);
    showStats = booleanDefault("showstats", showStats);
    keeppeace = booleanDefault("keeppeace", keeppeace);
    reportKills = booleanDefault("reportkills", reportKills);
#ifdef BRONCO_STD
    if (booleanDefault("galacticfrequent", 1)) { /* 7/27/91 TC */
	mapmode = 2;
    }
#else
    /* slightly different implementation of same thing */
    {	int i = 0;
	mapmode = 1 + booleanDefault("frequentmap", i);	/* ATM */
    }
#endif
    {
	extern int updateSpeed;
	int i;

	if ((i = numericDefault("updatespersec", 5, 1, 9)) > 0) {
	    switch (i) {
	      case 1: updateSpeed = 6; break;
	      case 2: updateSpeed = 5; break;
	      case 3: updateSpeed = 4; break;
	      case 4: updateSpeed = 3; break;
	      case 5: updateSpeed = 2; break;
	      case 6:
	      case 7: updateSpeed = 1; break;
	      case 8:
	      case 9: updateSpeed = 0; break;
	    }
	}
    }

    initkeymap();
    sendOptionsPacket();

    /* Set p_hostile to hostile, so if keeppeace is on, the guy starts off
       hating everyone (like a good fighter should) */
    me->p_hostile = (FED|ROM|KLI|ORI);

    sprintf(buf,
      "Maximum:      %2d  %3d %3d               %3d   %6d   %3d   %3d",
      0, 0, 0, 0, 0, 0, 0);
    W_WriteText(tstatw,50,27,textColor,buf,strlen(buf),W_RegularFont);
    me->p_planets=0;
    me->p_genoplanets=0;
    me->p_armsbomb=0;
    me->p_genoarmsbomb=0;
    /* Set up a reasonable default */
    me->p_whydead=KQUIT;
    me->p_team=ALLTEAM;
    s_type = defaultShip(CRUISER); /* from rlb7h 11/15/91 TC */
    setjmp(env);		/* Reentry point of game */
    /* give the player the motd and find out which team he wants */
    entrywindow(&team, &s_type);
    if (team == -1) {
	W_DestroyWindow(w);
	sendByeReq();
	sleep(1);
	printf("OK, bye!\n");
	exit(0);
    }
    getship(myship, s_type);
    redrawall = 1;
    enter();
    calibrate_stats();
    W_ClearWindow(w);
    /*
    for (i = 0; i < NSIG; i++) {
	sigset(i, SIG_IGN);
    }
    */

    me->p_status = PALIVE;			/* Put player in game */
    me->p_ghostbuster = 0;

    if (showStats)			/* Default showstats are on. */
	W_MapWindow(statwin); /* not for mwm compatibility 8/26/91 TC */
	redrawStats();

    /* Get input until the player quits or dies */
    input();
}

printUsage(prog)
	char	*prog;
{
	printf("Usage: %s [-r defaultfile] [-s socketnum] [-h hostname] [-d display-name]\n    [-p connect socketnum] [-H host-id]\n",prog);
}

reaper()
{
#ifdef hpux
    wait((int *) 0);
#else hpux
    while (wait3((union wait *) 0, WNOHANG, NULL) > 0)
	;
#endif hpux
}


#ifdef _UTS
char *alloca(size)
int size;
{
    extern char *malloc();
    return((char *) malloc(size));
}
#endif

