/* rsa_key.c
 * 
 * Ray Jones 
 */
#include "copyright2.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include "defs.h"
#include "packets.h"
#include "Wlib.h"
#include "data.h"

#include "keys.h"

#ifdef GATEWAY
extern unsigned long netaddr;
extern int serv_port;
#endif

encryptRSAPacket(spacket, cpacket)
struct rsa_key_spacket *spacket;
struct rsa_key_cpacket *cpacket;
{
    struct sockaddr_in saddr;
    int len;
    u_short port;
    unsigned char *data;

#ifndef GATEWAY
    /* query the socket to determine the remote host (ATM) */
    len = sizeof(saddr);
    if (getpeername(sock, &saddr, &len) < 0) {
        perror("getpeername(sock)");
        exit(1);
    }
#else
    /* if we didn't get it from -H, go ahead and query the socket */
    if (netaddr == 0) {
	len = sizeof(saddr);
	if (getpeername(sock, &saddr, &len) < 0) {
	    perror("getpeername(sock)");
	    exit(1);
	}
    } else {
	saddr.sin_addr.s_addr = htonl(netaddr);
	saddr.sin_port = htons(serv_port);
    }
#endif

    /* replace the first few bytes of the message */
    /* will be the low order bytes of the number */
    data = spacket->data;
    bcopy (&saddr.sin_addr.s_addr, data, sizeof(saddr.sin_addr.s_addr));
    data += sizeof(saddr.sin_addr.s_addr);
    bcopy (&saddr.sin_port, data, sizeof(saddr.sin_port));

    /* do the actual computaions */
    rsa_encode(cpacket->resp, spacket->data, key_private, 
	       key_global, KEY_SIZE);
    
    bcopy(key_global, cpacket->global, KEY_SIZE);
    bcopy(key_public, cpacket->public, KEY_SIZE);
}

