/*
 * thd.h - global vars and configuration stuff
 *
 * trekhopd (Netrek firewall hop daemon)
 * By Andy McFadden
 */

/* files - adjust to taste */
#define LOGFILE		"thdlog"
#define CONFIGFILE	"thdrc"
#define USERFILE	"/tmp/thd.users"



/*
 * end of configurable stuff
 */

/* what version we are */
#define VERSION	"1.51"

#define TRUE	1
#define FALSE	0

/* deal with funky SVR3 signal mechanism */
#ifdef _UTS
# define SYSV
#endif
#ifdef SYSV
# define SIGNAL(sig,action) sigset(sig, action)
#else
# define SIGNAL(sig,action) signal(sig, action)
#endif

/* assorted library routines */
extern char *malloc();

/* global structure declarations */
typedef struct {
    char hostname[64];
    int port;
} SERVER;
typedef struct {
    unsigned char octet_addr[4];
} OCTET_HOST;

/* function prototypes */
extern void init_connections(/*void*/),
	    main_loop(/*void*/);
extern int strcasecmp(/*char *str1, char *str2*/),
	   handle_meta(/*int fd*/);
extern char *strcasestr(/*char *str, char *pat*/);
extern char *ctime();

/* global variables */
extern int verbose,
	   listen_port,
	   meta_listen_port,
	   meta_port,
	   approved_only,
	   approved_count,
	   local_origin_only,
	   localnet_count,
	   kill_all;
extern char *prog,
	    *meta_host;
extern SERVER *approved;
extern OCTET_HOST *localnet;

