/*
 * util.c - stuff which ought to be in clib (IMHO)
 *
 * trekhopd (Netrek firewall hop daemon)
 * By Andy McFadden
 */
#include <stdio.h>
#include <ctype.h>


/*
 * Like strcmp(), but case independent.
 */
int
strcasecmp(str1, str2)
register char *str1, *str2;
{
    while (*str1 && *str2 && toupper(*str1) == toupper(*str2))
	str1++, str2++;
    return (*str1 - *str2);
}


#ifdef NOT_USED
/*
 * Find first occurrence of string (case independent).  No claims on
 * optimality are made.  "pat" should have nonzero length.
 */
char *
strcasestr(str, pat)
register char *str, *pat;
{
    register char *sp, *pp;

    while (*str) {
	sp = str;
	pp = pat;
	while (toupper(*(sp++)) == toupper(*(pp++))) {
	    if (!(*sp)) return (NULL);          /* ran out of string */
	    if (!(*pp)) return (str);           /* we found a match! */
	}
	str++;
    }
    return (NULL);
}
#endif

